/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWStepAssignmentPanel
extends VWStepPropTabPanel {
    private int m_updatingCount = 0;
    private Object m_countSync = new Object();
    private static final int COL_NAME = 0;
    private static final int COL_EXPRESSION = 1;
    private VWStepDefinition m_stepDefinition;
    private VWTable m_assignmentTable;
    private VWAssignmentTableModel m_assignmentTableModel;
    private DefaultTableCellRenderer m_cellRenderer;
    private boolean m_bPreAssignment = true;
    private JPanel m_prePostPanel = null;
    private ButtonGroup m_grp = null;
    private JRadioButton m_preRadio;
    private JRadioButton m_postRadio;
    private ItemListener m_preRadioItemListener;
    private ItemListener m_postRadioItemListener;
    private JTextField m_milestoneUI;
    private String[][] m_preAssignments;
    private String[][] m_postAssignments;
    private VWToolbarBorder m_milestoneBorder = null;
    private VWToolbarBorder m_assignmentsBorder = null;

    public VWStepAssignmentPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 3;
        this.preSetupLayout();
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        try {
            this.setUpdating();
            this.m_stepDefinition = this.m_step != null ? this.m_step.getStepDefinition() : null;
            if (this.m_stepDefinition != null) {
                this.m_preAssignments = this.m_stepDefinition.getPreAssignments();
                this.m_postAssignments = this.m_stepDefinition.getPostAssignments();
            } else {
                this.m_preAssignments = null;
                this.m_postAssignments = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        finally {
            this.doneUpdating();
        }
    }

    private void createRenderers() {
        this.m_cellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                component.applyComponentOrientation(compOrientation);
                Object tooltip = null;
                if (component != null && component instanceof JLabel) {
                    if (value != null && value instanceof String) {
                        ((JLabel)component).setText((String)value);
                        ((JLabel)component).setToolTipText(VWStringUtils.formatToolTip((String)value, 0));
                    } else {
                        ((JLabel)component).setText(null);
                        ((JLabel)component).setToolTipText(VWStringUtils.formatToolTip(null, 0));
                    }
                }
                return component;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preSetupLayout() {
        try {
            this.setUpdating();
            this.m_prePostPanel = new JPanel();
            this.m_prePostPanel.setLayout(new BoxLayout(this.m_prePostPanel, 2));
            this.m_preRadio = new JRadioButton(VWResource.s_beforeExecution);
            this.m_postRadio = new JRadioButton(VWResource.s_afterCompletion);
            this.m_grp = new ButtonGroup();
            this.m_grp.add(this.m_preRadio);
            this.m_grp.add(this.m_postRadio);
            this.m_preRadio.setSelected(this.m_bPreAssignment);
            this.m_prePostPanel.add(this.m_preRadio);
            this.m_prePostPanel.add(this.m_postRadio);
            this.m_preRadioItemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (!VWStepAssignmentPanel.this.m_bLayoutInitialized || VWStepAssignmentPanel.this.isUpdating()) {
                        return;
                    }
                    if (e.getStateChange() == 1 && !VWStepAssignmentPanel.this.m_bPreAssignment) {
                        VWStepAssignmentPanel.this.m_bPreAssignment = true;
                        VWStepAssignmentPanel.this.updateDisplay();
                    }
                }
            };
            this.m_preRadio.addItemListener(this.m_preRadioItemListener);
            this.m_postRadioItemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (!VWStepAssignmentPanel.this.m_bLayoutInitialized || VWStepAssignmentPanel.this.isUpdating()) {
                        return;
                    }
                    if (e.getStateChange() == 1 && VWStepAssignmentPanel.this.m_bPreAssignment) {
                        VWStepAssignmentPanel.this.m_bPreAssignment = false;
                        VWStepAssignmentPanel.this.updateDisplay();
                    }
                }
            };
            this.m_postRadio.addItemListener(this.m_postRadioItemListener);
            this.m_milestoneBorder = new VWToolbarBorder(VWResource.s_milestone, 0);
            JPanel panel = this.m_milestoneBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_milestoneUI = new JTextField();
            this.m_milestoneUI.setEditable(false);
            panel.add((Component)this.m_milestoneUI, "First");
            this.initAssignmentModel();
            this.createRenderers();
            if (this.m_assignmentTable != null) {
                TableColumnModel columnModel = this.m_assignmentTable.getColumnModel();
                TableColumn columnName = columnModel.getColumn(0);
                TableColumn columnExpression = columnModel.getColumn(1);
                columnName.setCellRenderer(this.m_cellRenderer);
                columnExpression.setCellRenderer(this.m_cellRenderer);
            }
            this.m_assignmentsBorder = new VWToolbarBorder(VWResource.s_fieldAssignments, 0);
            panel = this.m_assignmentsBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(this.m_assignmentTable);
            panel.add((Component)scrollPane, "Center");
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 2;
            c.anchor = 23;
            this.add((Component)this.m_prePostPanel, c);
            c.gridx = 0;
            ++c.gridy;
            c.anchor = 23;
            c.weightx = 1.0;
            this.add((Component)this.m_milestoneBorder, c);
            ++c.gridy;
            c.fill = 1;
            c.weighty = 1.0;
            this.add((Component)this.m_assignmentsBorder, c);
        }
        finally {
            this.doneUpdating();
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
    }

    protected void setupLayout() {
        this.updateDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplay() {
        try {
            this.setUpdating();
            if (this.m_stepDefinition != null) {
                // empty if block
            }
            this.initAssignmentModel();
            this.m_milestoneUI.setText(this.getMilestone());
        }
        finally {
            this.doneUpdating();
        }
    }

    private String getMilestone() {
        String milestone = null;
        if (!this.m_step.isComponentStep()) {
            milestone = this.m_bPreAssignment ? this.m_stepDefinition.getPreMilestone() : this.m_stepDefinition.getPostMilestone();
        }
        if (milestone == null) {
            milestone = VWResource.s_none;
        }
        return milestone;
    }

    private String[][] getAssignments() {
        if (this.m_bPreAssignment) {
            return this.m_preAssignments;
        }
        return this.m_postAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAssignmentModel() {
        try {
            this.setUpdating();
            if (this.m_assignmentTableModel == null) {
                this.m_assignmentTableModel = new VWAssignmentTableModel();
                if (this.m_assignmentTable == null) {
                    this.m_assignmentTable = new VWTable(this.m_assignmentTableModel);
                } else {
                    this.m_assignmentTable.setModel(this.m_assignmentTableModel);
                }
            } else {
                this.m_assignmentTableModel.fireTableDataChanged();
            }
        }
        finally {
            this.doneUpdating();
        }
    }

    protected boolean isStepView() {
        return this.m_bStepView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            return this.m_updatingCount > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            ++this.m_updatingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doneUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            if (this.m_updatingCount > 0) {
                --this.m_updatingCount;
            }
        }
    }

    public void removeReferences() {
        int j;
        int i;
        super.removeReferences();
        this.m_stepDefinition = null;
        if (this.m_assignmentTable != null) {
            this.m_assignmentTable.removeReferences();
            this.m_assignmentTable = null;
        }
        if (this.m_assignmentTableModel != null) {
            this.m_assignmentTableModel.removeReferences();
            this.m_assignmentTableModel = null;
        }
        if (this.m_prePostPanel != null) {
            this.m_prePostPanel.setLayout(null);
            this.m_prePostPanel.removeAll();
            this.m_prePostPanel = null;
        }
        if (this.m_grp != null) {
            this.m_grp.remove(this.m_preRadio);
            this.m_grp.remove(this.m_postRadio);
            this.m_grp = null;
        }
        if (this.m_milestoneBorder != null) {
            this.m_milestoneBorder.removeReferences();
            this.m_milestoneBorder = null;
        }
        if (this.m_assignmentsBorder != null) {
            this.m_assignmentsBorder.removeReferences();
            this.m_assignmentsBorder = null;
        }
        this.m_cellRenderer = null;
        if (this.m_preRadio != null) {
            this.m_preRadio.removeItemListener(this.m_preRadioItemListener);
            this.m_preRadio = null;
        }
        if (this.m_postRadio != null) {
            this.m_postRadio.removeItemListener(this.m_postRadioItemListener);
            this.m_postRadio = null;
        }
        this.m_milestoneUI = null;
        if (this.m_preAssignments != null) {
            for (i = 0; i < this.m_preAssignments.length; ++i) {
                for (j = 0; j < this.m_preAssignments[i].length; ++j) {
                    this.m_preAssignments[i][j] = null;
                }
                this.m_preAssignments[i] = null;
            }
            this.m_preAssignments = null;
        }
        if (this.m_postAssignments != null) {
            for (i = 0; i < this.m_postAssignments.length; ++i) {
                for (j = 0; j < this.m_postAssignments[i].length; ++j) {
                    this.m_postAssignments[i][j] = null;
                }
                this.m_postAssignments[i] = null;
            }
            this.m_postAssignments = null;
        }
        this.m_countSync = null;
        this.removeAll();
    }

    private class VWAssignmentTableModel
    extends AbstractTableModel {
        String[][] m_assignments = null;
        String[] m_columnNames = new String[]{VWResource.s_name, VWResource.s_expression};

        VWAssignmentTableModel() {
        }

        public int getRowCount() {
            String[][] assignments = VWStepAssignmentPanel.this.getAssignments();
            if (assignments != null) {
                return assignments.length;
            }
            return 0;
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int col) {
            if (col < 0 || col >= this.m_columnNames.length) {
                return null;
            }
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            if (col < 0 || col >= this.getColumnCount()) {
                return null;
            }
            String[][] assignments = VWStepAssignmentPanel.this.getAssignments();
            if (assignments != null) {
                return assignments[row][col];
            }
            return null;
        }

        public void removeReferences() {
            this.m_assignments = null;
            if (this.m_columnNames != null) {
                for (int i = 0; i < this.m_columnNames.length; ++i) {
                    this.m_columnNames[i] = null;
                }
                this.m_columnNames = null;
            }
        }
    }
}

